import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { getDefaultTvm, TvmClientMode } from '../../../../../models/ui';
import { LinkToSecret } from '../../../../../models/ui/secrets';
import { stageWithSecretsDecorator } from '../../../../../modules/secrets/storybook/stageWithSecretsDecorator';
import { apiServicesContextDecorator } from '../../../../../stories';
import { DevForm } from '../../../../lib';

import { TvmSubForm } from './TvmSubForm';

// noinspection SpellCheckingInspection
const initialValues = {
   tvm: {
      ...getDefaultTvm(),
      enabled: true,
      clients: [
         {
            mode: TvmClientMode.GetCheck,
            source: {
               app: 123456,
               alias: '',
            },
            destinations: [
               {
                  app: 234567,
                  alias: '123',
               },
               {
                  app: 345678,
                  alias: '',
               },
            ],
            secret: {
               alias: 'sec-01dpnnv45fmwbfhfqgqy344zz7:ver-01dpnnv45pwtmtmg2766j7qwm2',
               key: 'PORT',
            } as LinkToSecret,
         },
         {
            mode: TvmClientMode.CheckOnly,
            source: {
               app: 123456,
               alias: '',
            },
         },
      ],
   },
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <TvmSubForm readonly={boolean('readonly', false)} disabled={boolean('disabled', false)} name={'tvm'} />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   decorators: [apiServicesContextDecorator, stageWithSecretsDecorator('du_manual_secrets')],
   title: 'components/stage-levels/deployUnit/TvmSubForm',
} as Meta;
