import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { EXTERNAL_LINKS } from '../../../../../models';

export function TvmHint() {
   return (
      <>
         <p>
            TVM Tool Settings. See <ExternalLink href={EXTERNAL_LINKS.wiki.tvm}>documentation</ExternalLink> for
            details.
         </p>
         <p>
            TVM tool takes your quota in addition to requested in Deploy Unit: Disk Size (950MB per Pod), RAM (30MB per
            Pod), CPU (0.1 per Pod). See <ExternalLink href={EXTERNAL_LINKS.deployDocs.tvmQuota}>here</ExternalLink> for
            details.
         </p>
      </>
   );
}

export function TvmClientPortHint() {
   return (
      <>
         <p>Port number on which tvmtool listens. It binds to loopback interface only. The default port is 2.</p>
      </>
   );
}

export function TvmBlackboxHint() {
   return (
      <>
         <p>
            Blackbox instances to check tickets. You can choose any option, if the container does not check user
            tickets. This option only affects the behavior of the request /tvm/checkusr.
         </p>
         <p>
            See <ExternalLink href={`${EXTERNAL_LINKS.wiki.tvm}#lokalno`}>documentation</ExternalLink> for details
         </p>
      </>
   );
}

export function TvmDestinationHint() {
   return (
      <>
         <p>Aliases and application identifiers that you intend to connect with service tickets</p>
      </>
   );
}

export function TvmSecretHint() {
   return (
      <>
         <p>Secret is used for generating secret env var with predefined name TVM_CLIENT_SECRET.</p>
         <p>
            {' '}
            TVM_CLIENT_SECRET env var is written to tvmtool's workload spec only and used for generating tvmtool config.
         </p>
      </>
   );
}
