import React from 'react';
import { EnabledSwitcherField } from '../../../../forms';

import classes from './YasmPodAgentSubForm.module.css';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const YasmPodAgentSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => (
   <div className={classes.wrapper}>
      <EnabledSwitcherField
         name={`${name}.addPodAgentUserSignals`}
         disabled={disabled}
         readonly={readonly}
         label={'Add pod agent user signals'}
         readonlyDots={true}
      />
   </div>
));

YasmPodAgentSubForm.displayName = 'YasmPodAgentSubForm';
