import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { apiServicesContextDecorator } from '../../../../../stories';
import { DevForm } from '../../../../lib';

import { YasmSubForm } from './YasmSubForm';

const initialValues = {
   yasm: {
      yasmTags: {
         itype: 'deploy-ui',
         tags: [
            {
               key: 'ctype',
               value: 'unknown',
            },
            {
               key: 'geo',
               value: 'sas',
            },
         ],
      },
   },
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <YasmSubForm readonly={boolean('readonly', false)} disabled={boolean('disabled', false)} name={'yasm'} />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/deployUnit/YasmSubForm',
   decorators: [apiServicesContextDecorator],
} as Meta;
