import React from 'react';

import { YasmTagsSubForm } from '../../../_common/YasmTagsSubForm/YasmTagsSubForm';
import { YasmPodAgentSubForm } from './YasmPodAgentSubForm';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const YasmSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => (
   <>
      <YasmTagsSubForm name={`${name}.yasmTags`} readonly={readonly} disabled={disabled} />

      <YasmPodAgentSubForm name={`${name}.podAgent`} readonly={readonly} disabled={disabled} />
   </>
));

YasmSubForm.displayName = 'YasmSubForm';
