import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { ExtendedFieldConfig, json } from '@yandex-infracloud-ui/libs';
import { Formik, FormikConfig } from 'formik';
import React from 'react';
import { number, object } from 'yup';

import { AntiaffinityRecord, getDefaultAntiaffinity } from '../../../../../models/ui';
import { LegoButton } from '../../../../../_lego';

import { AntiaffinityRecordField } from './AntiaffinityRecordField';

const initialValues = {
   age: getDefaultAntiaffinity(),
   empty: getDefaultAntiaffinity(),
   regular: getDefaultAntiaffinity(),
   withError: null,
};

const antiaffinityRecordValidationSchema = object<AntiaffinityRecord>({
   perRack: number().nullable(),
   perNode: number().nullable(),
});

type FormValue = typeof initialValues;

function FieldStory(props: ExtendedFieldConfig<FormValue>) {
   const config: FormikConfig<FormValue> = {
      initialTouched: {
         withError: true as any,
      },
      initialValues,
      onSubmit: action('onSubmit'),
      validateOnMount: true,
      validationSchema: object({
         withError: antiaffinityRecordValidationSchema,
         xField: antiaffinityRecordValidationSchema,
      }),
   };

   return (
      <Formik {...config}>
         {form => (
            <div style={{ ['--forms-field-layout' as any]: 'column' }}>
               <AntiaffinityRecordField placeholder={'Placeholder'} {...props} />
               <br />
               <LegoButton theme={'action'} type={'submit'} text={'Submit'} />

               <pre>{json(form)}</pre>
            </div>
         )}
      </Formik>
   );
}

export const Regular = () => <FieldStory name={'regular'} label={'Regular'} />;

export const Disabled = () => <FieldStory name={'regular'} label={'Disabled'} disabled={true} />;

export const Readonly = () => <FieldStory name={'regular'} label={'Readonly'} readonly={true} />;

export const Empty = () => <FieldStory name={'empty'} label={'Readonly & Empty'} readonly={true} />;

export const WithError = () => <FieldStory name={'withError'} label={'With error'} />;

export const Playground = () => (
   <FieldStory
      name={'regular'}
      label={text('label', 'label')}
      placeholder={text('placeholder', 'placeholder')}
      required={boolean('required', false)}
      disabled={boolean('disabled', false)}
      readonly={boolean('readonly', false)}
      help={text('help', 'help text')}
      hint={text('hint', 'short hint')}
      hidden={boolean('hidden', false)}
   />
);

export default {
   title: 'components/stage-levels/deployUnit/fields/AntiaffinityRecordField',
} as Meta;
