import {
   classNames,
   ExtendedFieldConfig,
   FieldLayout2,
   OptionalNumberInput,
   useExtendedField,
} from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { AntiaffinityRecord, getDefaultAntiaffinity } from '../../../../../models/ui';

import classes from './AntiaffinityRecordField.module.css';

export const AntiaffinityRecordField = React.memo((props: ExtendedFieldConfig<any, AntiaffinityRecord>) => {
   const { field, onChange, onBlur, readonly, disabled } = useExtendedField(props);
   const value = field.value ?? getDefaultAntiaffinity();

   const handlePerNodeChange = useCallback((v: number | null) => onChange({ ...value, perNode: v }), [onChange, value]);

   const handlePerRecChange = useCallback((v: number | null) => onChange({ ...value, perRack: v }), [onChange, value]);

   return (
      <FieldLayout2 {...props}>
         <div className={classNames(classes.wrapper, { [classes.readonly]: readonly })}>
            <div data-test={'Antiaffinity:PerNode'}>
               <OptionalNumberInput
                  disabled={disabled}
                  readonly={readonly}
                  value={value.perNode}
                  onChange={handlePerNodeChange}
                  onBlur={onBlur}
                  name={`${field.name}:perNode`}
               >
                  <span className={classes.label}>Per node</span>
               </OptionalNumberInput>
            </div>

            <div data-test={'Antiaffinity:PerRack'}>
               <OptionalNumberInput
                  disabled={disabled}
                  readonly={readonly}
                  value={value.perRack}
                  onChange={handlePerRecChange}
                  onBlur={onBlur}
                  name={`${field.name}:perRack`}
               >
                  <span className={classes.label}>Per rack</span>
               </OptionalNumberInput>
            </div>
         </div>
      </FieldLayout2>
   );
});

AntiaffinityRecordField.displayName = 'AntiaffinityRecordField';
