import { ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import { Select } from 'lego-on-react';
import React, { useCallback } from 'react';

import { TvmBlackboxOptions } from '../../../../../models/ui';

// TODO Когда починят иконки, перейти на использование YCSelect
export const BlackboxSelectFieldField = React.memo((props: ExtendedFieldConfig<any, string>) => {
   const { field, disabled, onBlur, onChange, readonly } = useExtendedField(props);

   const handleChange = useCallback(
      (values: string | string[]) => {
         const v = values[0];

         onChange(v);
         onBlur();
      },
      [onBlur, onChange],
   );

   return (
      <FieldLayout2 {...props}>
         <Select
            theme={'normal'}
            type={'radio'}
            size={'s'}
            name={field.name}
            placeholder={'Select value'}
            onChange={handleChange}
            disabled={disabled || readonly}
            val={field.value}
         >
            {TvmBlackboxOptions.map(item => (
               <Select.Item key={item.value} val={item.value}>
                  {item.title}
               </Select.Item>
            ))}
         </Select>
      </FieldLayout2>
   );
});

BlackboxSelectFieldField.displayName = 'BlackboxSelectFieldField';
