import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { DiskStaticResource } from '../../../../../models/ui';

import { DevForm } from '../../../../lib';

import { DiskStaticResourcesSubForm } from './DiskStaticResourcesSubForm';

const initialValues = {
   default: [] as DiskStaticResource[],
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DiskStaticResourcesSubForm
                  name={'default'}
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  soxService={boolean('soxService', false)}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/box/fields/StaticResourcesSubForm',
} as Meta;
