import { faBan, faCode, faKey } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React from 'react';

import { StaticResourceFileType } from '../../../../../../../models/ui';

import classes from './FileIcon.module.css';

interface Props {
   showText?: boolean;
   type: StaticResourceFileType;
}

const icons = {
   [StaticResourceFileType.Raw]: faCode,
   [StaticResourceFileType.Secret]: faKey,
   [StaticResourceFileType.Unknown]: faBan,
};

const text = {
   [StaticResourceFileType.Raw]: 'Raw',
   [StaticResourceFileType.Secret]: 'Secret',
   [StaticResourceFileType.Unknown]: 'Unknown',
};

export function FileIcon({ type, showText = false }: Props) {
   return (
      <>
         <FontAwesomeIcon icon={icons[type]} className={classes.icon} />
         {showText && text[type]}
      </>
   );
}
