import { FormChangeListener, InputField2, IPureValueProps, TextField2 } from '@yandex-infracloud-ui/libs';
import { Formik } from 'formik';
import React from 'react';

import { RawFile } from '../../../../../../../models/ui';

export const rawInitialFormParams = {
   raw: null as string | null,
   name: null as string | null,
};

type RawFormParams = typeof rawInitialFormParams;

export function getRawFormParams(file: RawFile): RawFormParams {
   return {
      name: file.name,
      raw: file?.raw ?? null,
   };
}

interface Props extends IPureValueProps<RawFormParams> {
   readonly?: boolean;
}

export const RawFileSubForm: React.FC<Props> = React.memo(({ readonly = false, value, onChange }) => (
   <Formik initialValues={value} onSubmit={onChange}>
      {() => (
         <>
            <FormChangeListener onChange={onChange} />

            <InputField2
               name={'name'}
               label={'Name'}
               required={!readonly}
               readonly={readonly}
               readonlyDots={readonly}
            />

            <TextField2
               controlProps={{ monospaceFont: true, readonlyPre: readonly }}
               label={!readonly ? 'Raw' : null}
               name={'raw'}
               readonly={readonly}
               required={!readonly}
            />
         </>
      )}
   </Formik>
));

RawFileSubForm.displayName = 'RawFileSubForm';
