import { EMPTY_VALUE, RemoveButton } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';

import { SelectedSecretName } from '../../../../../../modules/secrets';
import { StaticResourceFile, StaticResourceFileType } from '../../../../../../models/ui';
import CopyToClipboard from '../../../../../../old-code/components/CopyToClipboard/CopyToClipboard';
import { handleStopPropagation } from '../../../../../../utils';
import { FileIcon } from './FileIcon/FileIcon';

import classes from './FileRowSubForm.module.css';

interface Props {
   value: StaticResourceFile;
   readonly: boolean;

   onSelect(v: string, i?: number): void;

   onRemove(v: string, i?: number): void;
}

export const FileRowSubForm: React.FC<Props> = React.memo(({ value, readonly, onSelect, onRemove }) => {
   const handleEditFile = useCallback(() => {
      if (value?.name) {
         /* eslint-disable-next-line no-underscore-dangle */
         onSelect(value.name, value._order);
      }
   }, [value, onSelect]);

   const handleRemoveFile = useCallback(() => {
      if (value?.name) {
         /* eslint-disable-next-line no-underscore-dangle */
         onRemove(value.name, value._order);
      }
   }, [value, onRemove]);

   if (!value) {
      return null;
   }
   return (
      <tr onClick={handleEditFile}>
         <td className={classes.nameColumn}>
            <span title={value.name ?? ''}>
               <FileIcon type={value.type} showText={false} />
               {value.name}
            </span>
         </td>

         <td className={classes.sourceColumn} colSpan={value.type === StaticResourceFileType.Raw ? 1 : 2}>
            <span>
               {value.type === StaticResourceFileType.Raw ? (
                  value.raw?.substr(0, 100) ?? EMPTY_VALUE
               ) : value.type === StaticResourceFileType.Secret ? (
                  <SelectedSecretName selectedSecret={value.secret!} />
               ) : (
                  'unknown file type'
               )}
            </span>
         </td>

         {value.type === StaticResourceFileType.Raw && (
            /* eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions */
            <td className={classes.copyValue} onClick={handleStopPropagation}>
               <CopyToClipboard value={value.raw} />
            </td>
         )}

         {!readonly && (
            /* eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions */
            <td className={classes.removeFile} onClick={handleStopPropagation}>
               <RemoveButton onClick={handleRemoveFile} />
            </td>
         )}
      </tr>
   );
});

FileRowSubForm.displayName = 'FileRowSubForm';
