import { YCSelectItem } from '@yandex-data-ui/common';
import { ExternalLink, WarningPlate } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React from 'react';

import { EXTERNAL_LINKS } from '../../../../../models';
import { activePatcherRevisions, DeployUnit, preferredPatcherRevision } from '../../../../../models/ui';
import { YCSelectField } from '../../../../forms';

import classes from './RuntimeVersionSubForm.module.css';

const PatchersRevisionsOptions: YCSelectItem[] = activePatcherRevisions
   .toArray()
   .sort((a, b) => a - b)
   .reverse()
   .map(revision => ({
      value: revision,
      title: `${revision}`,
   }));

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const RuntimeVersionSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => {
   const form = useFormikContext();
   const { value, initialValue } = form.getFieldMeta<DeployUnit['patchersRevision']['value']>(name);

   return (
      <div className={classes.wrapper}>
         <YCSelectField
            type={'single'}
            name={name}
            label={'Runtime version'}
            controlProps={{
               items: PatchersRevisionsOptions,
               showSearch: false,
               allowEmptyValue: true,
            }}
            hint={
               <>
                  Enable new runtime version for{' '}
                  <ExternalLink href={EXTERNAL_LINKS.deployDocs.patchersRevision}>new features</ExternalLink>.
               </>
            }
            required={true}
            disabled={disabled}
            readonly={readonly}
            readonlyDots={readonly}
         />

         {/* 1) версия не выбрана, 2) выбрана версия ниже рекомендуемой, 3) поменялось значение */}
         {!value || value < preferredPatcherRevision || value !== initialValue ? (
            // DEPLOY-5379
            <WarningPlate theme={!value || value < 3 ? 'danger' : 'warning'}>
               Currently we advise Runtime version {preferredPatcherRevision}+.
               <br />
               Beware that enabling runtime version will cause mass pods reallocation.{' '}
               <ExternalLink href={EXTERNAL_LINKS.deployDocs.patchersRevision}>Read more</ExternalLink>
            </WarningPlate>
         ) : null}
      </div>
   );
});

RuntimeVersionSubForm.displayName = 'RuntimeVersionSubForm';
