import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { EXTERNAL_LINKS } from '../../../models';

export function AntiaffinityHint() {
   return (
      <>
         <p>Restrictions on pods collocation to topology zones (Node, Rack, DC)</p>
      </>
   );
}

export function DisruptionBudgetHint() {
   return (
      <>
         <p>
            The number of pods of your service that may be unavailable at a time (for example, due to transfer between
            hosts or due to the process of deploying out a new release).
         </p>
         <p>
            Going beyond the disruption budget is an abnormal situation that can be associated with an accident, an
            error in the service, etc.
         </p>
      </>
   );
}

export function MaxTolerableDowntimePodsHint() {
   return (
      <>
         <p>Max number of pods that may be evicted or may become unavailable because of maintenance.</p>
      </>
   );
}

export function MaxTolerableDowntimeSecondsHint() {
   return (
      <>
         <p>Max allowed hardware maintenance duration in seconds during which pods may be unavailable ({'<= 3600'}).</p>
      </>
   );
}

export function DeployUnitLocationHint() {
   return (
      <>
         <p>Location and a number of pods in each location.</p>
         <p>Your service will be deployed into selected locations.</p>
      </>
   );
}

export function DeployUnitTypeHint() {
   return (
      <>
         <p>
            Deployment unit type is a rule, which defines, how many Replica Sets will be created and how they will
            manage pods and disruption budgets in different locations.
         </p>
         <p>Two unit types are supported:</p>
         <dl>
            <dt>Per-cluster replica set</dt>
            <dd>
               Deploy Unit consists of a set of independent ReplicaSets - one per locations, each with its own
               independent disruption budget.
            </dd>

            <dt>Multi-cluster replica set</dt>
            <dd>Deploy Unit consists of one Multi-cluster Replica Set with a general disruption budget.</dd>
         </dl>
      </>
   );
}

export function PodSettingsHint() {
   return (
      <>
         <p>
            See <ExternalLink href={EXTERNAL_LINKS.deployDocs.pod}>documentation</ExternalLink> for details.
         </p>
      </>
   );
}

export function ResourceRequestsHint() {
   return (
      <>
         <p>
            Computational resources that will be allocated for each pod of your service. See{' '}
            <ExternalLink href={EXTERNAL_LINKS.deployDocs.resourceRequests}>documentation</ExternalLink> for details.
         </p>
      </>
   );
}

export function AnonymousMemoryLimitHint() {
   return (
      <>
         <p>
            See <ExternalLink href={EXTERNAL_LINKS.wiki.anonymousMemoryLimit}>documentation</ExternalLink> for details.
         </p>
      </>
   );
}

export function NetworkIdHint() {
   return (
      <>
         <p>
            Project network where your service will be launched. See{' '}
            <ExternalLink href={EXTERNAL_LINKS.wiki.projectNetwork}>documentation</ExternalLink> for details.
         </p>
      </>
   );
}

export function EndpointSetsHint() {
   return (
      <>
         <p>Network port to be exposed to YP service discovery to be used by service clients.</p>
      </>
   );
}

export function YasmHint() {
   return (
      <>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.yasmUnistat}>documentation</ExternalLink> for details.
      </>
   );
}

export function LogbrokerHint() {
   return (
      <>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.logbrokerToolsChangelog}>changelog</ExternalLink> for
         details.
      </>
   );
}

export function PodAgentHint() {
   return (
      <>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.podAgent}>changelog</ExternalLink> for details.
      </>
   );
}

export function DiskLayersHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.layers}>documentation</ExternalLink> for details.
      </p>
   );
}

export function DiskBaseLayerHint() {
   return (
      <p>
         You can use default images for base layers of your instances (by default it is the image of Ubuntu Xenial
         [16.04]). See <ExternalLink href={EXTERNAL_LINKS.docs.rtcImages}>documentation</ExternalLink> for details.
      </p>
   );
}

export function DiskStaticResourcesHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.staticResources}>documentation</ExternalLink> for details.
      </p>
   );
}

export function AccessPermissionsHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.accessPermissions}>documentation</ExternalLink> for details.
      </p>
   );
}

export function TransmitSystemLogsHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.transmitSystemLogs}>documentation</ExternalLink> for details.
      </p>
   );
}

export function LayerSourceFileStoragePolicyHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.layerSourceFileStoragePolicy}>documentation</ExternalLink>{' '}
         for details.
      </p>
   );
}
