import { faRocket as faRocketChanged } from '@fortawesome/free-solid-svg-icons';

import {
   Box,
   DeployUnit,
   DeployUnitFormParams,
   deployUnitSchema,
   deployUnitToFormParams,
   getEmptyDeployUnit,
   formParamsToDeployUnit,
   stageLevels,
   DeployUnitEmptyParams,
   ypViewConfig,
} from '../../../models/ui';
import { FormLevelConfig } from '../../huge-form';
import { clearBoxOnClone } from '../box/levelConfig';

import { DeployUnitForm } from './components/DeployUnitForm/DeployUnitForm';

const clearDeployUnitOnClone = (du: DeployUnit) => {
   for (const box of du.boxes) {
      clearBoxOnClone(box);
   }
};

export const deployUnitLevelConfig: FormLevelConfig<DeployUnitFormParams, DeployUnit, Box, DeployUnitEmptyParams> = {
   clearOnClone: clearDeployUnitOnClone,
   component: DeployUnitForm,
   getEmptyValue: getEmptyDeployUnit,
   formParamsToValue: formParamsToDeployUnit,
   getChildren: du => du.boxes,
   icon: ypViewConfig.deployUnit.fontAwesomeIcon,
   iconChanged: faRocketChanged,
   iconColor: ypViewConfig.deployUnit.cssColor,
   id: stageLevels.deployUnit.id,
   level: stageLevels.deployUnit.level,
   name: 'Deploy Unit',
   renderTitle: () => 'Deploy unit settings',
   routePath: id => `/${ypViewConfig.deployUnit.smallPrefix}-${id}`,
   validationSchema: deployUnitSchema,
   valueToFormParams: deployUnitToFormParams,
};
