import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { Stage } from '../../../../../models/ui';
import { apiServicesContextDecorator, configContextDecorator, routerDecorator } from '../../../../../stories';

import { stageLevelConfig } from '../../levelConfig';
import { StageForm } from './StageForm';

const value: Stage = {
   ...stageLevelConfig.getEmptyValue(),
   id: 'test-stage',
   project: { id: 'test-project', accountId: 'abc:service:3443' },
};

const form = {
   formParams: stageLevelConfig.valueToFormParams(value),
   hasChildren: false,
   id: 'test-stage',
   levelConfig: stageLevelConfig,
   parentForms: [],
   value,
};

export const Regular = () => (
   <Formik initialValues={form.formParams} onSubmit={() => undefined}>
      {formik => (
         <StageForm
            disabled={boolean('disabled', false)}
            form={form}
            formik={formik}
            isRootEntityNew={boolean('isRootEntityNew', false)}
            readonly={boolean('readonly', false)}
         />
      )}
   </Formik>
);

export default {
   decorators: [configContextDecorator, apiServicesContextDecorator, routerDecorator],
   title: 'components/stage-levels/stage/StageForm',
} as Meta;
