import { InputField2, isEqual } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { DeployUnit, Stage, StageFormParams } from '../../../../../models/ui';
import { TagsField } from '../../../../forms/fields/TagsField/TagsField';
import { SubFormProps } from '../../../../huge-form';
import { useIsApprovalRequired } from '../../../../stage-huge-form/formHooks';
import { editOnlyForNewProps } from '../../../_common/utils';

import { EnabledSwitcherField } from '../../../../forms';

import { SoxServiceHint, StageIdHint, TagsHint } from '../../hints';
import { InfraSubForm } from '../InfraSubForm/InfraSubForm';
import { ProjectSubForm } from '../ProjectSubForm/ProjectSubForm';
import { TransferToProjectWarning } from '../TransferToProjectWarning/TransferToProjectWarning';

import classes from './StageForm.module.css';

export const StageForm: React.FC<SubFormProps<StageFormParams, Stage, DeployUnit>> = ({
   disabled,
   form,
   formik,
   isRootEntityNew,
   readonly,
}) => {
   const newProject = formik.values.project;
   const currentProject = form.formParams.project;
   const isApprovalRequired = useIsApprovalRequired(form.value.id, isRootEntityNew);

   return (
      <div className={classes.form}>
         <InputField2
            name={'id'}
            label={'Stage ID'}
            help={isRootEntityNew ? 'Stage ID can not be changed after creation' : undefined}
            hint={<StageIdHint />}
            {...editOnlyForNewProps(readonly, disabled, form.isAdded, isRootEntityNew)}
            readonlyDots={true}
         />

         <ProjectSubForm name={'project'} readonly={readonly} disabled={disabled} />

         {!isRootEntityNew && newProject && currentProject ? (
            isEqual(newProject.id, currentProject.id) ? null : (
               <TransferToProjectWarning currentProject={currentProject} newProject={newProject} />
            )
         ) : null}

         <TagsField
            name={'tags'}
            label={'Tags'}
            readonly={readonly}
            disabled={disabled}
            hint={<TagsHint />}
            readonlyDots={true}
         />

         <EnabledSwitcherField
            name={'soxService'}
            label={'Sox service'}
            hint={<SoxServiceHint />}
            readonly={readonly}
            disabled={disabled}
            required={true}
            readonlyDots={true}
         />

         <InfraSubForm name={'infra'} readonly={readonly} disabled={disabled} isApprovalRequired={isApprovalRequired} />
      </div>
   );
};
