import { ExternalLink, WarningPlate } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { Link } from 'react-router-dom';

import { EXTERNAL_LINKS, urlBuilder } from '../../../../../models';
import { ProjectItem } from '../../../../../models/ui';

import classes from './TransferToProjectWarning.module.css';

interface Props {
   currentProject: ProjectItem;
   newProject: ProjectItem;
}

export function TransferToProjectWarning({ currentProject, newProject }: Props) {
   const newAccountId = newProject.accountId;
   const currentAccountId = currentProject.accountId;

   const newAbcServiceId = getAbcServiceId(newAccountId);
   const currentAbcServiceId = getAbcServiceId(currentAccountId);

   const newProjectLink = <Link to={urlBuilder.project(newProject.id)}>{newProject.id}</Link>;
   const oldProjectLink = <Link to={urlBuilder.project(currentProject.id)}>{currentProject.id}</Link>;

   return (
      <WarningPlate
         className={classes.warning}
         secondRaw={
            <ol>
               <li>
                  The roles assigned to the stage within the project {oldProjectLink} will be revoked.
                  <br /> We advise you to verify and configure roles in settings of current project {oldProjectLink} and
                  new project {newProjectLink}.
               </li>
               <li>
                  Current logs of the stage will no longer be available in UI. They will still be available via{' '}
                  <ExternalLink href={EXTERNAL_LINKS.yqlStageLogsQuery(currentProject.id, currentProject.id)}>
                     YT interface
                  </ExternalLink>
                  .
               </li>

               {/* если account id поменялся (он может совпадать у разных проектов) */}
               {newAccountId !== currentAccountId ? (
                  <>
                     <li>
                        These fields will be cleared: <code>/meta/account_id</code>, <code>/spec/account_id</code>.
                     </li>

                     {newAbcServiceId && newAbcServiceId !== currentAbcServiceId ? (
                        <li>
                           {/* ABC-service quota */}
                           Stage will be deployed using quota from new ABC-service{' '}
                           <ExternalLink href={EXTERNAL_LINKS.abcService(newAbcServiceId)}>
                              #{newAbcServiceId}
                           </ExternalLink>
                           .
                        </li>
                     ) : newAccountId === 'tmp' ? (
                        <li>
                           {/* temporary quota */}
                           Project is using temporary quota. Y.Deploy won&#39;t guarantee availability of stages in this
                           project, they can be deleted at any time. You have to use this option for testing only. We
                           are going to send notifications about using temporary quota to every user in abc-groups, that
                           are listed in an ACL.{' '}
                           <ExternalLink href={EXTERNAL_LINKS.docs.rtcQuotas}>YP Quota documentation</ExternalLink>
                        </li>
                     ) : null}
                  </>
               ) : null}
            </ol>
         }
      >
         <p>
            <b>Transferring stage to project {newProjectLink}!</b>
         </p>
         <p>
            You have to redeploy this stage and update revision of all deploy units manually for these changes to take
            effect. See{' '}
            <ExternalLink href={EXTERNAL_LINKS.deployDocs.transferToProject} className={'test'}>
               documentation
            </ExternalLink>{' '}
            for details.
         </p>
      </WarningPlate>
   );
}

function getAbcServiceId(accountId: 'tmp' | string) {
   return /^abc:service:\d+$/.test(accountId) ? parseInt(accountId.replace(/^abc:service:/, ''), 10) : undefined;
}
