import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { Link } from 'react-router-dom';
import { EXTERNAL_LINKS, urlBuilder } from '../../../models';

export function StageIdHint() {
   return (
      <>
         <p>Name of the created Stage object.</p>
      </>
   );
}

export function ProjectIdHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.project}>documentation</ExternalLink> for details.
      </p>
   );
}

export function SoxServiceHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.sox}>documentation</ExternalLink> for details.
      </p>
   );
}

export function TagsHint() {
   return (
      <>
         <p>
            Projects and Stages can be assigned with several tags and filtered by them (using <code>#hashtag</code>) on
            the <Link to={urlBuilder.home()}>index page</Link>.
         </p>
         <p>
            For example:
            <code>prod</code>, <code>test</code>, <code>dev</code>, <code>temp</code>, and any another custom tag.
         </p>
      </>
   );
}
