import { faServer as faServerChanged } from '@fortawesome/free-solid-svg-icons';

import {
   DeployUnit,
   formParamsToStage,
   getEmptyStage,
   Stage,
   StageEmptyParams,
   StageFormParams,
   stageLevels,
   stageToFormParams,
   stageValidationSchema,
   ypViewConfig,
} from '../../../models/ui';
import { FormLevelConfig } from '../../huge-form';
import { StageForm } from './components/StageForm/StageForm';

export const stageLevelConfig: FormLevelConfig<StageFormParams, Stage, DeployUnit, StageEmptyParams> = {
   component: StageForm,
   getEmptyValue: getEmptyStage,
   formParamsToValue: formParamsToStage,
   getChildren: s => s.deployUnits,
   icon: ypViewConfig.stage.fontAwesomeIcon,
   iconChanged: faServerChanged,
   iconColor: ypViewConfig.stage.cssColor,
   id: stageLevels.stage.id,
   level: stageLevels.stage.level,
   name: 'Stage',
   renderTitle: () => 'Stage settings',
   routePath: id => `/${ypViewConfig.stage.smallPrefix}-${id}`,
   validationSchema: stageValidationSchema,
   valueToFormParams: stageToFormParams,
};
