import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { Box, DeployUnit, Stage, Workload } from '../../../../../models/ui';
import {
   apiServicesContextDecorator,
   configContextDecorator,
   modalsSupportDecorator,
   routerDecorator,
} from '../../../../../stories';
import { boxLevelConfig } from '../../../box/levelConfig';
import { deployUnitLevelConfig } from '../../../deployUnit/levelConfig';

import { stageLevelConfig } from '../../../stage/levelConfig';
import { workloadLevelConfig } from '../../levelConfig';
import { WorkloadForm } from './WorkloadForm';

const workload: Workload = {
   ...workloadLevelConfig.getEmptyValue(),
   id: 'test-workload',
};

const box: Box = {
   ...boxLevelConfig.getEmptyValue(),
   id: 'test-box',
};

const deployUnit: DeployUnit = {
   ...deployUnitLevelConfig.getEmptyValue(),
   id: 'test-deployUnit',
};

const stage: Stage = {
   ...stageLevelConfig.getEmptyValue(),
   id: 'test-stage',
};

const form = {
   formParams: workloadLevelConfig.valueToFormParams(workload),
   hasChildren: false,
   id: 'test-workload',
   levelConfig: workloadLevelConfig,
   parentForms: [
      {
         formParams: boxLevelConfig.valueToFormParams(box),
         hasChildren: true,
         id: 'test-box',
         levelConfig: boxLevelConfig,
         parentForms: [],
         value: box,
      },
      {
         formParams: deployUnitLevelConfig.valueToFormParams(deployUnit),
         hasChildren: true,
         id: 'test-deployUnit',
         levelConfig: deployUnitLevelConfig,
         parentForms: [],
         value: deployUnit,
      },
      {
         formParams: stageLevelConfig.valueToFormParams(stage),
         hasChildren: true,
         id: 'test-stage',
         levelConfig: stageLevelConfig,
         parentForms: [],
         value: stage,
      },
   ],
   value: workload,
};

export const Regular = () => (
   <Formik initialValues={form.formParams} onSubmit={() => undefined}>
      {formik => (
         <WorkloadForm
            disabled={boolean('disabled', false)}
            form={form}
            formik={formik}
            isRootEntityNew={boolean('isRootEntityNew', false)}
            readonly={boolean('readonly', false)}
         />
      )}
   </Formik>
);

export default {
   decorators: [configContextDecorator, modalsSupportDecorator, apiServicesContextDecorator, routerDecorator],
   title: 'components/stage-levels/workload/WorkloadForm',
} as Meta;
