import React, { useContext } from 'react';

import { FieldLayout2, InputField2 } from '@yandex-infracloud-ui/libs';

import { SidecarName, Workload, WorkloadFormParams } from '../../../../../models/ui';
import { SecretsReloadContext } from '../../../../../models/ui/secrets';
import { EnvSubForm } from '../../../../../modules/environment/components/EnvSubForm/EnvSubForm';
import { SecretsContext } from '../../../../../modules/secrets';
import { EnabledSwitcherField } from '../../../../forms';
import { SubFormProps } from '../../../../huge-form';
import { SidecarResourcePlate } from '../../../../stage-huge-form/components';
import { getInitialIds } from '../../../../../models/ui/stage/form-utils';
import { useSecretsContextValueFromForm } from '../../../_common/useSecretsContextValueFromForm';
import { editOnlyForNewProps } from '../../../_common/utils';
import { CoredumpSubForm } from '../../fields/CoredumpSubForm/CoredumpSubForm';
import { WorkloadCommandsSubForm } from '../../fields/WorkloadCommandsSubForm/WorkloadCommandsSubForm';
import { CommandsHint, EnvironmentHint, LogsHint } from '../../hints';
import { YasmSubForm } from '../YasmSubForm/YasmSubForm';

import classes from './WorkloadForm.module.css';

export const WorkloadForm: React.FC<SubFormProps<WorkloadFormParams, Workload, any>> = ({
   disabled,
   form,
   formik,
   isRootEntityNew,
   readonly,
}) => {
   const reloadSecretUsages = useContext(SecretsReloadContext);
   const { deployUnit, box, workload } = getInitialIds(form.formParams, form.parentForms, form.levelConfig.id);

   return (
      <SecretsContext.Provider value={useSecretsContextValueFromForm(form, reloadSecretUsages)}>
         <div className={classes.form}>
            <InputField2
               name={'id'}
               label={'Workload ID'}
               {...editOnlyForNewProps(readonly, disabled, form.isAdded, isRootEntityNew)}
               readonlyDots={true}
            />

            <EnabledSwitcherField
               name={'logs'}
               label={'Logs'}
               readonly={readonly}
               required={true}
               hint={<LogsHint />}
               readonlyDots={true}
            />

            {formik.values.logs && (
               <SidecarResourcePlate
                  sidecar={SidecarName.Logbroker}
                  deployUnit={deployUnit}
                  box={box}
                  workload={workload}
               />
            )}

            <br />

            <FieldLayout2
               name={'commands'}
               label={'Commands and probes'}
               hint={<CommandsHint />}
               hideErrors={true}
               bigLabel={true}
            >
               <WorkloadCommandsSubForm name={'commands'} readonly={readonly} disabled={disabled} />
            </FieldLayout2>

            <FieldLayout2
               name={'environment'}
               label={'Environment variables'}
               hint={<EnvironmentHint />}
               bigLabel={true}
            >
               <EnvSubForm name={'environment'} readonly={readonly} />
            </FieldLayout2>

            <FieldLayout2 name={'yasm'} label={'Monitoring in YASM'} bigLabel={true} hideErrors={true}>
               <YasmSubForm name={'yasm'} readonly={readonly} disabled={disabled} />
            </FieldLayout2>

            <CoredumpSubForm name={'coredumpPolicy'} readonly={readonly} disabled={disabled} form={form} />
         </div>
      </SecretsContext.Provider>
   );
};
