import { CheckboxField2, FieldLayout2 } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React from 'react';
import { WorkloadPortoYasm } from '../../../../../models/ui';

import { EnabledSwitcherField, FormSubSection } from '../../../../forms';
import { YasmTagsSubForm } from '../../../_common/YasmTagsSubForm/YasmTagsSubForm';
import { YasmTagsInheritanceHint } from '../../hints';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const YasmPortoSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<WorkloadPortoYasm>(name);

   const { usePortoMetrics } = value;
   return (
      <FormSubSection>
         <FieldLayout2 name={`${name}.porto`} label={'Per workload porto metrics'} bigLabel={true} readonly={readonly}>
            {!readonly || !usePortoMetrics ? (
               <EnabledSwitcherField
                  name={`${name}.usePortoMetrics`}
                  label={null}
                  disabled={disabled}
                  readonly={readonly}
               />
            ) : null}

            {usePortoMetrics && (
               <>
                  <YasmTagsSubForm name={`${name}.yasmTags`} readonly={readonly} disabled={disabled} />

                  <CheckboxField2
                     name={`${name}.inheritMissedLabels`}
                     disabled={disabled}
                     readonly={readonly}
                     readonlyDots={readonly}
                     label={'Labels inheritance'}
                     controlProps={{ disableIndeterminate: true }}
                     hint={<YasmTagsInheritanceHint />}
                  >
                     Inherit missing labels
                  </CheckboxField2>
               </>
            )}
         </FieldLayout2>
      </FormSubSection>
   );
});

YasmPortoSubForm.displayName = 'YasmPortoSubForm';
