import React from 'react';
import { YasmPortoSubForm } from '../YasmPortoSubForm/YasmPortoSubForm';
import { YasmUnistatSubForm } from '../YasmUnistatSubForm/YasmUnistatSubForm';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const YasmSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => (
   <>
      <YasmUnistatSubForm name={`${name}.unistats`} readonly={readonly} disabled={disabled} />

      <YasmPortoSubForm name={`${name}.porto`} readonly={readonly} disabled={disabled} />
   </>
));

YasmSubForm.displayName = 'YasmSubForm';
