import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { apiServicesContextDecorator } from '../../../../../stories';
import { DevForm } from '../../../../lib';

import { YasmUnistatRecord } from './YasmUnistatRecord';
import { noop } from '../../../../../utils';

const initialValues = {
   yasm: {
      url: '',
      port: null,
      yasmTags: {
         itype: 'deploy-ui',
         tags: [
            {
               key: 'ctype',
               value: 'unknown',
            },
            {
               key: 'geo',
               value: 'sas',
            },
         ],
      },
   },
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <YasmUnistatRecord
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'yasm'}
                  onRemove={noop}
                  onRestore={noop}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/workload/YasmSubForm',
   decorators: [apiServicesContextDecorator],
} as Meta;
