import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { ExtendedFieldConfig, json } from '@yandex-infracloud-ui/libs';
import { Formik, FormikConfig } from 'formik';
import React from 'react';
import { object } from 'yup';
import { LegoButton } from '../../../../../_lego';
import { coredumpPolicyValidationSchema } from '../../../../../models/ui';

import { CoredumpSubForm } from './CoredumpSubForm';

const emptyCoredump = {};

const defaultCoredump = {
   countLimit: 2,
   totalSizeLimitMegabytes: 500,
   probability: 100,

   aggregator: {
      enabled: true,
   },
};

const initialValues = {
   countLimit: 2,
   totalSizeLimitMegabytes: 500,
   probability: 100,

   aggregator: {
      enabled: true,
   },
   default: defaultCoredump,
   empty: emptyCoredump,
   withError: {
      ...defaultCoredump,
      probability: -1,
   },
};

type FormValue = typeof initialValues;

function FieldStory(props: ExtendedFieldConfig<FormValue>) {
   const config: FormikConfig<FormValue> = {
      initialTouched: {
         withError: true as any,
      },
      initialValues,
      onSubmit: action('onSubmit'),
      validateOnMount: true,
      validationSchema: object({
         default: coredumpPolicyValidationSchema,
         withError: coredumpPolicyValidationSchema,
         xField: coredumpPolicyValidationSchema,
      }),
   };

   return (
      <Formik {...config}>
         {form => (
            <div style={{ ['--forms-field-layout' as any]: 'column' }}>
               <CoredumpSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'coredumpPolicy'}
               />
               <br />
               <LegoButton theme={'action'} type={'submit'} text={'Submit'} />

               <pre>{json(form)}</pre>
            </div>
         )}
      </Formik>
   );
}

export const Default = () => <FieldStory name={'default'} label={'Default'} />;

export const Empty = () => <FieldStory name={'empty'} label={'Empty'} />;

export const Disabled = () => <FieldStory name={'default'} label={'Disabled'} disabled={true} />;

export const Readonly = () => <FieldStory name={'default'} label={'Readonly'} readonly={true} />;

export const WithError = () => <FieldStory name={'withError'} label={'With error'} />;

export const Playground = () => (
   <FieldStory
      name={'default'}
      label={text('label', 'label')}
      placeholder={text('placeholder', 'placeholder')}
      required={boolean('required', false)}
      disabled={boolean('disabled', false)}
      readonly={boolean('readonly', false)}
      help={text('help', 'help text')}
      hint={text('hint', 'short hint')}
      hidden={boolean('hidden', false)}
   />
);

export default {
   title: 'components/stage-levels/workload/fields/CoredumpSubForm',
} as Meta;
