import { IconDefinition } from '@fortawesome/pro-regular-svg-icons';

import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';

import classes from './CommandFormTab.module.css';

export interface Props {
   // Смотри комментарий к FormTabProps.__ROLE
   __ROLE?: 'FormTab';

   emptyIcon?: IconDefinition;
   fillIcon?: IconDefinition;
   id: string;
   isEmpty?: boolean;
   title: ReactNode;
   errorsCount?: number;
   dataTest?: string;
}

export const CommandFormTab: React.FC<Props> = React.memo(
   ({ title, isEmpty, emptyIcon, fillIcon, errorsCount, dataTest }) => {
      let icon: ReactNode = null;
      if (isEmpty === true && emptyIcon) {
         icon = <FontAwesomeIcon icon={emptyIcon} fixedWidth={true} />;
      } else if (isEmpty === false && fillIcon) {
         icon = <FontAwesomeIcon icon={fillIcon} fixedWidth={true} />;
      }

      return (
         <div className={classNames(classes.wrapper, { [classes.withSubTitle]: !!errorsCount })} data-test={dataTest}>
            <div className={classes.title}>
               <span>{title}</span>
               <span> {icon}</span>
            </div>
            {!!errorsCount && <span className={classes.error}>Errors count: {errorsCount}</span>}
         </div>
      );
   },
);

CommandFormTab.defaultProps = {
   // Смотри комментарий к FormTab.defaultProps
   __ROLE: 'FormTab',
};

CommandFormTab.displayName = 'CommandFormTab';
