import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { getEmptyWorkload } from '../../../../../models/ui';
import { DevForm } from '../../../../lib';

import { WorkloadCommandsSubForm } from './WorkloadCommandsSubForm';

const initialValues = {
   commands: { ...getEmptyWorkload().commands },
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <div style={{ '--forms-field-layout': 'column' } as any}>
               <WorkloadCommandsSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'commands'}
               />
               <DevForm />
            </div>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/workload/fields/WorkloadCommandsSubForm',
} as Meta;
