import { TextField2 } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { ExecCommandLineHint } from '../hints';

import { AdvancedFieldSet, AdvancedSettingsSubForm } from './AdvancedSettingsSubForm';
import classes from './CommandSubForm.module.css';

interface Props {
   dataE2e?: string;
   disabled: boolean;
   name: string;
   readonly: boolean;
   sections?: Set<AdvancedFieldSet>;
}

export const CommandSubForm: React.FC<Props> = React.memo(({ dataE2e, name, readonly, disabled, sections }) => (
   <div className={classes.wrapper} data-test={dataE2e}>
      <TextField2
         name={`${name}.command`}
         label={!readonly ? 'Command line' : null}
         hint={<ExecCommandLineHint />}
         help={!readonly ? 'The command is simply executed, it is not run inside a shell' : undefined}
         disabled={disabled}
         readonly={readonly}
         hideErrors={true}
         controlProps={{ monospaceFont: true, readonlyPre: readonly }}
      />

      <AdvancedSettingsSubForm
         name={name}
         toggleText={'Advanced settings'}
         sections={
            sections ?? new Set([AdvancedFieldSet.Access, AdvancedFieldSet.Limits, AdvancedFieldSet.RetryPolicy])
         }
         readonly={readonly}
         disabled={disabled}
      />
   </div>
));

CommandSubForm.displayName = 'CommandSubForm';
