import { CheckboxField2, EnumField2, EnumOption, InputField2, TextField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React from 'react';

import { WorkloadCommands, WorkloadProbeMode } from '../../../../../../models/ui';

import { AdvancedFieldSet, AdvancedSettingsSubForm } from './AdvancedSettingsSubForm';
import { CommandSubForm } from './CommandSubForm';
import classes from './ProbeSubForm.module.css';

const modes: EnumOption[] = [
   { value: WorkloadProbeMode.HTTP, title: 'HTTP' },
   { value: WorkloadProbeMode.Exec, title: 'Exec' },
   { value: WorkloadProbeMode.TCP, title: 'TCP' },
];

interface Props {
   dataE2e?: string;
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const ProbeSubForm: React.FC<Props> = React.memo(({ dataE2e, name, disabled, readonly }) => {
   const form = useFormikContext<WorkloadCommands>();
   const mode: WorkloadProbeMode = getIn(form.values, `${name}.mode`);
   const isHttpAny = getIn(form.values, `${name}.http.any`, false);

   return (
      <div className={classes.wrapper} data-test={dataE2e}>
         <EnumField2
            name={`${name}.mode`}
            label={null}
            controlProps={{ options: modes }}
            readonly={readonly}
            disabled={disabled}
            hideErrors={true}
         />

         {mode === WorkloadProbeMode.HTTP ? (
            <>
               <div className={classes.http}>
                  <InputField2
                     name={`${name}.http.path`}
                     label={'Path'}
                     placeholder={'/'}
                     readonly={readonly}
                     disabled={disabled}
                     hideErrors={true}
                  />

                  <InputField2
                     name={`${name}.http.port`}
                     label={'Port'}
                     readonly={readonly}
                     disabled={disabled}
                     controlProps={{ controlProps: { min: 0 }, type: 'number' }}
                     hideErrors={true}
                  />

                  <TextField2
                     name={`${name}.http.expectedAnswer`}
                     label={'Expected answer'}
                     controlProps={{ minRows: 1, monospaceFont: true, readonlyPre: readonly }}
                     disabled={disabled || isHttpAny}
                     readonly={readonly}
                     hideErrors={true}
                  />

                  <CheckboxField2
                     name={`${name}.http.any`}
                     label={''}
                     readonly={readonly}
                     disabled={disabled}
                     controlProps={{ disableIndeterminate: true }}
                     hideErrors={true}
                  >
                     Any answer
                  </CheckboxField2>
               </div>

               <AdvancedSettingsSubForm
                  name={`${name}.http`}
                  sections={new Set([AdvancedFieldSet.RetryPolicy])}
                  toggleText={'Retry policy'}
                  readonly={readonly}
                  disabled={disabled}
               />
            </>
         ) : null}

         {mode === WorkloadProbeMode.Exec ? (
            <CommandSubForm name={`${name}.exec`} readonly={readonly} disabled={disabled} dataE2e={`${name}.exec`} />
         ) : null}

         {mode === WorkloadProbeMode.TCP ? (
            <div className={classes.tcp}>
               <InputField2
                  name={`${name}.tcp.port`}
                  label={'Port'}
                  readonly={readonly}
                  disabled={disabled}
                  controlProps={{ controlProps: { min: 0 }, type: 'number' }}
                  hideErrors={true}
               />

               <AdvancedSettingsSubForm
                  name={`${name}.tcp`}
                  sections={new Set([AdvancedFieldSet.RetryPolicy])}
                  toggleText={'Retry policy'}
                  readonly={readonly}
                  disabled={disabled}
               />
            </div>
         ) : null}
      </div>
   );
});

ProbeSubForm.displayName = 'ProbeSubForm';
