import { CheckboxField2, EnumField2, EnumOption, InputField2, TextField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React from 'react';

import { WorkloadCommands, WorkloadStopMode } from '../../../../../../models/ui';
import { MaxTriesHint } from '../hints';

import { AdvancedFieldSet, AdvancedSettingsSubForm } from './AdvancedSettingsSubForm';
import { CommandSubForm } from './CommandSubForm';

import classes from './StopSubForm.module.css';
import { UnixSignalSubForm } from './UnixSignalSubForm';

const modes: EnumOption[] = [
   { value: WorkloadStopMode.HTTP, title: 'HTTP' },
   { value: WorkloadStopMode.Exec, title: 'Exec' },
   { value: WorkloadStopMode.UnixSignal, title: 'Unix Signal' },
];

interface Props {
   dataE2e?: string;
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const StopSubForm: React.FC<Props> = React.memo(({ dataE2e, name, disabled, readonly }) => {
   const form = useFormikContext<WorkloadCommands>();
   const mode: WorkloadStopMode = getIn(form.values, `${name}.mode`);
   const isHttpAny = getIn(form.values, `${name}.http.any`, false);

   return (
      <div className={classes.wrapper} data-test={dataE2e}>
         <InputField2
            name={`${name}.maxTries`}
            label={'Max tries'}
            hint={<MaxTriesHint />}
            controlProps={{ controlProps: { min: 0 }, type: 'number' }}
            readonly={readonly}
            disabled={disabled}
            hideErrors={true}
         />

         <EnumField2
            name={`${name}.mode`}
            label={null}
            readonly={readonly}
            disabled={disabled}
            controlProps={{ options: modes }}
            hideErrors={true}
         />

         {mode === WorkloadStopMode.HTTP ? (
            <>
               <div className={classes.http}>
                  <InputField2
                     name={`${name}.http.path`}
                     label={'Path'}
                     placeholder={'/'}
                     readonly={readonly}
                     disabled={disabled}
                     hideErrors={true}
                  />

                  <InputField2
                     name={`${name}.http.port`}
                     label={'Port'}
                     readonly={readonly}
                     disabled={disabled}
                     controlProps={{ controlProps: { min: 0 }, type: 'number' }}
                     hideErrors={true}
                  />

                  <TextField2
                     name={`${name}.http.expectedAnswer`}
                     label={'Expected answer'}
                     controlProps={{ minRows: 1, monospaceFont: true, readonlyPre: readonly }}
                     disabled={disabled || isHttpAny}
                     readonly={readonly}
                     hideErrors={true}
                  />

                  <CheckboxField2
                     name={`${name}.http.any`}
                     label={''}
                     readonly={readonly}
                     disabled={disabled}
                     controlProps={{ disableIndeterminate: true }}
                     hideErrors={true}
                  >
                     Any answer
                  </CheckboxField2>
               </div>

               <AdvancedSettingsSubForm
                  name={`${name}.http`}
                  sections={new Set([AdvancedFieldSet.RetryPolicy])}
                  toggleText={'Retry policy'}
                  readonly={readonly}
                  disabled={disabled}
               />
            </>
         ) : null}

         {mode === WorkloadStopMode.Exec ? (
            <CommandSubForm name={`${name}.exec`} readonly={readonly} disabled={disabled} dataE2e={`${name}.exec`} />
         ) : null}
         {mode === WorkloadStopMode.UnixSignal ? (
            <UnixSignalSubForm
               name={`${name}.unixSignal`}
               readonly={readonly}
               disabled={disabled}
               dataE2e={`${name}.unixSignal`}
            />
         ) : null}
      </div>
   );
});

StopSubForm.displayName = 'StopSubForm';
