import { YCSelect } from '@yandex-data-ui/common';
import { EMPTY_VALUE } from '@yandex-infracloud-ui/libs';
import { useField } from 'formik';
import React from 'react';

import { EUnixSignalType } from '../../../../../../proto-typings';
import { AdvancedFieldSet, AdvancedSettingsSubForm, RetryPolicyFields } from './AdvancedSettingsSubForm';

import classes from './UnixSignalSubForm.module.css';

interface Props {
   dataE2e?: string;
   disabled: boolean;
   name: string;
   readonly: boolean;
   sections?: Set<AdvancedFieldSet>;
}

const signalItems = [
   ...Object.values(EUnixSignalType).map(type => ({
      value: type,
      title: type,
   })),
];

export const UnixSignalSubForm: React.FC<Props> = React.memo(({ dataE2e, name, readonly, disabled, sections }) => {
   const [signalField, , helpers] = useField(`${name}.signal`);

   const handleChange = (newValue: string) => {
      helpers.setValue(newValue as EUnixSignalType);
   };

   return (
      <div className={classes.wrapper} data-test={dataE2e}>
         <div className={classes.fieldsWrapper}>
            {readonly ? (
               <p>{signalField.value || EMPTY_VALUE}</p>
            ) : (
               <YCSelect
                  allowEmptyValue
                  items={signalItems}
                  onUpdate={handleChange}
                  value={signalField.value}
                  disabled={disabled}
               />
            )}
         </div>

         <AdvancedSettingsSubForm
            name={name}
            toggleText={'Retry policy'}
            sections={sections ?? new Set([AdvancedFieldSet.RetryPolicy])}
            readonly={readonly}
            disabled={disabled}
            disabledRetryPolicyFields={[RetryPolicyFields.MaxExecutionTimeMs]}
         />
      </div>
   );
});

UnixSignalSubForm.displayName = 'UnixSignalSubForm';
