import { renderBytes, renderDurationMs } from '@yandex-infracloud-ui/libs';
import { FormikProps, getIn } from 'formik';

import { renderVcpu } from '../../../../../forms';

const renderDetails = (fieldName: string, form: FormikProps<any>, renderer: (v: number) => string): string => {
   const value = getIn(form.values, fieldName, 0);

   return value > 0 ? renderer(value) : '';
};

export const renderDurationHelp = (n: string, f: FormikProps<any>): string => renderDetails(n, f, renderDurationMs);

export const renderCpuHelp = (n: string, f: FormikProps<any>): string => renderDetails(n, f, renderVcpu);

export const renderBytesHelp = (n: string, f: FormikProps<any>): string => renderDetails(n, f, renderBytes);
