import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { EXTERNAL_LINKS } from '../../../models';

export function CommandsHint() {
   return (
      <>
         Workload settings that indicate how to properly start, stop and check the liveliness of the workload. See{' '}
         <ExternalLink href={EXTERNAL_LINKS.deployDocs.workloadCommands}>documentation</ExternalLink> for details.
      </>
   );
}

export function EnvironmentHint() {
   return (
      <>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.workloadEnvironment}>documentation</ExternalLink> for
         details.
      </>
   );
}

export function LogsHint() {
   return (
      <>
         <p>
            Enable stdout and stderr log delivery. Logs produced by application to stdout and stderr will be
            automatically collected and be available for viewing in Logs tab for 2 days. They will also be delivered to{' '}
            <ExternalLink href={EXTERNAL_LINKS.logsYT()}>YT</ExternalLink> for archival purposes.
         </p>

         <p>
            See <ExternalLink href={EXTERNAL_LINKS.deployDocs.logs}>documentation</ExternalLink> for details.
         </p>

         <p>
            Logs take your quota <b>in addition</b> to requested in Deploy Unit: Disk Size (3GB per Pod), RAM (512MB per
            Pod), CPU (0.4 per Pod).
            <br />
            See <ExternalLink href={EXTERNAL_LINKS.deployDocs.logsQuota}>here</ExternalLink> for details.
         </p>

         <p>Please, keep in mind, logs throughput is limited to 500 KBps per Stage!</p>
      </>
   );
}

export function YasmUnistatHint() {
   return (
      <>
         Unistat URL and monitoring port, through which you can set up monitoring in YASM. See{' '}
         <ExternalLink href={EXTERNAL_LINKS.deployDocs.yasmUnistat}>documentation</ExternalLink> for details.
      </>
   );
}

export function YasmTagsInheritanceHint() {
   return (
      <>
         Turn on to enable label inheritance from Deploy Unit settings. See{' '}
         <ExternalLink href={EXTERNAL_LINKS.deployDocs.yasmTagsInheritance}>documentation</ExternalLink> for details.
      </>
   );
}

export function CoredumpHint() {
   return (
      <p>
         Coredumps collection and aggregation settings.
         <br />
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.coredump}>documentation</ExternalLink> for details.
      </p>
   );
}
