import { faHeartRate as faHeartRateChanged } from '@fortawesome/pro-solid-svg-icons';
import {
   getEmptyWorkload,
   formParamsToWorkload,
   stageLevels,
   Workload,
   WorkloadFormParams,
   workloadToFormParams,
   workloadValidationSchema,
   WorkloadEmptyParams,
   ypViewConfig,
} from '../../../models/ui';
import { clearTokensFromEnvironment } from '../../../modules/environment';

import { FormLevelConfig } from '../../huge-form';
import { WorkloadForm } from './components/WorkloadForm/WorkloadForm';

export const clearWorkloadOnClone = (w: Workload) => clearTokensFromEnvironment(w.environment);

export const workloadLevelConfig: FormLevelConfig<WorkloadFormParams, Workload, any, WorkloadEmptyParams> = {
   clearOnClone: clearWorkloadOnClone,
   component: WorkloadForm,
   getEmptyValue: getEmptyWorkload,
   formParamsToValue: formParamsToWorkload,
   getChildren: () => [],
   icon: ypViewConfig.workload.fontAwesomeIcon,
   iconChanged: faHeartRateChanged,
   iconColor: ypViewConfig.workload.cssColor,
   id: stageLevels.workload.id,
   level: stageLevels.workload.level,
   name: 'Workload',
   renderTitle: () => 'Workload settings',
   routePath: id => `/${ypViewConfig.workload.smallPrefix}-${id}`,
   validationSchema: workloadValidationSchema,
   valueToFormParams: workloadToFormParams,
};
