import { select } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React, { useState } from 'react';

import { StageConverter } from '../../../models/ui';
import { stageWithDynamicResources } from '../../../stories';
import { DevJson } from '../../lib';

import { StagePart, StagePartType } from './models';
import { SelectStagePart } from './SelectStagePart';

export const Regular = () => {
   const stage = StageConverter.fromApi(stageWithDynamicResources);
   const [value, setValue] = useState<StagePart | null>(null);

   return (
      <>
         <SelectStagePart
            stage={stage}
            type={select('type', StagePartType, StagePartType.Resource)}
            placeholder={'Select stage resource...'}
            value={value}
            onChange={setValue}
         />
         <DevJson>{value}</DevJson>
      </>
   );
};

export default {
   title: 'components/stage/SelectStagePart',
} as Meta;
