import { classNames } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';
import { partTypeMap, StagePart, StagePartType } from './models';

import classes from './StagePartItem.module.css';
import { StagePartItemView } from './StagePartItemView';

interface Props {
   part: StagePart;
   selected: boolean;
   targetPartType: StagePartType;

   onSelect(part: StagePart): void;
}

export const StagePartItem: React.FC<Props> = React.memo(({ part, selected, targetPartType, onSelect }) => {
   const options = partTypeMap.get(part.type)!;

   const handleSelect = useCallback(() => {
      if (targetPartType === part.type) {
         onSelect(part);
      }
   }, [onSelect, part, targetPartType]);

   const isTarget = targetPartType === part.type;

   const className = classNames(classes.item, classes[`level_${options.level}`], {
      [classes.selected]: selected,
      [classes.target]: isTarget,
   });

   return (
      // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
      <li className={className} onClick={handleSelect}>
         <StagePartItemView part={part} isTarget={isTarget} withDeployUnit={false} />
      </li>
   );
});

StagePartItem.displayName = 'StagePartItem';
