import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React from 'react';

import { ResourceType } from '../../../models/ui';
import { StagePartType } from './models';
import { StagePartItemView } from './StagePartItemView';

export const Wide = () => (
   <div style={{ width: '40rem' }}>
      <StagePartItemView
         isTarget={boolean('isTarget', true)}
         part={{
            box: 'box',
            deployUnit: 'du',
            resource: { id: 'very_very_very_very_very_very_very_very_id', type: ResourceType.StaticResource },
            stage: 'stage',
            type: StagePartType.Resource,
            workload: 'workload',
         }}
         withDeployUnit={boolean('withDeployUnit', false)}
      />
   </div>
);

export const Narrow = () => (
   <div style={{ width: '15rem' }}>
      <StagePartItemView
         isTarget={boolean('isTarget', true)}
         part={{
            box: 'box',
            deployUnit: 'du',
            resource: { id: 'very_very_very_very_very_very_very_very_id', type: ResourceType.StaticResource },
            stage: 'stage',
            type: StagePartType.Resource,
            workload: 'workload',
         }}
         withDeployUnit={boolean('withDeployUnit', false)}
      />
   </div>
);

export default {
   title: 'components/stage/StagePartItemView',
} as Meta;
