import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { ResourceType } from '../../../models/ui';

import { partTypeMap, StagePart, StagePartType } from './models';
import classes from './StagePartItemView.module.css';

interface Props {
   className?: string;
   isTarget: boolean;
   part: StagePart;
   withDeployUnit: boolean;
}

export const StagePartItemView: React.FC<Props> = ({ className, part, isTarget, withDeployUnit }) => {
   const options = partTypeMap.get(part.type)!;
   const id = options.getId(part);

   return (
      <div className={classNames(classes.item, className, { [classes.target]: isTarget })}>
         <FontAwesomeIcon icon={options.icon} style={{ color: options.iconColor }} className={classes.icon} />

         <div className={classes.id} title={id}>
            {id}
         </div>

         <div className={classes.separator} />

         <div className={classNames(classes.type)}>
            {withDeployUnit &&
            part.deployUnit &&
            part.type !== StagePartType.Stage &&
            part.type !== StagePartType.DeployUnit
               ? `${part.deployUnit} / `
               : ''}

            {part.type === StagePartType.Resource ? (
               part.resource?.type === ResourceType.Layer ? (
                  <span title={'Layer'}>L</span>
               ) : part.resource?.type === ResourceType.StaticResource ? (
                  <span title={'Static Resource'}>SR</span>
               ) : part.resource?.type === ResourceType.DynamicResource ? (
                  <span title={'Dynamic Resource'}>DR</span>
               ) : (
                  <span title={'Resource type is unknown for UI'}>?</span>
               )
            ) : (
               options.name
            )}
         </div>
      </div>
   );
};

StagePartItemView.displayName = 'StagePartItemView';
