import { faBoxOpen, faCode, faHeartRate, faRocket, faServer, IconDefinition } from '@fortawesome/pro-regular-svg-icons';

import { Resource } from '../../../models/ui';

export enum StagePartType {
   Stage = 'stage',
   DeployUnit = 'deployUnit',
   Box = 'box',
   Workload = 'workload',

   // eslint-disable-next-line
   Resource = 'resource',
}

export interface StagePart {
   box?: string;
   deployUnit?: string;
   resource?: Resource;
   stage: string;
   type: StagePartType;
   workload?: string;
}

export interface StagePartTypeOptions {
   icon: IconDefinition;
   iconColor: string;
   level: number;
   name: string;

   getId(part: StagePart): string;
}

export const partTypeMap = new Map<StagePartType, StagePartTypeOptions>([
   [
      StagePartType.Stage,
      {
         level: 1,
         name: 'Stage',
         icon: faServer,
         iconColor: 'black',
         getId: p => p.stage,
      },
   ],
   [
      StagePartType.DeployUnit,
      {
         level: 2,
         name: 'Deploy unit',
         icon: faRocket,
         iconColor: '#ff9a00',
         getId: p => p.deployUnit!,
      },
   ],
   [
      StagePartType.Box,
      {
         level: 3,
         name: 'Box',
         icon: faBoxOpen,
         iconColor: '#2fa2ce',
         getId: p => p.box!,
      },
   ],
   [
      StagePartType.Workload,
      {
         level: 4,
         name: 'Workload',
         icon: faHeartRate,
         iconColor: '#45d496',
         getId: p => p.workload!,
      },
   ],
   [
      StagePartType.Resource,
      {
         level: 3,
         name: 'Resource',
         icon: faCode,
         iconColor: 'orange',
         getId: p => p.resource?.id ?? '',
      },
   ],
]);
