import { Card, Popover } from '@yandex-cloud/uikit';
import { formatDate } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';
import { stageStatusesMap } from '../../../models/ui';
import { TStageSpec } from '../../../proto-typings';
import { useStage } from '../../../redux';
import { Status, StatusType } from '../../lib';

import classes from './StageCard.module.css';

const StageStatusBadge: React.FC<{ stageId: string }> = ({ stageId }) => {
   const { stageStatusLabel, meta, stage } = useStage(stageId, false, true);

   if (!stage || !stageStatusLabel || meta.isProcessing) {
      return null;
   }

   const { state, additional } = stageStatusLabel;

   const status = (
      <Status type={StatusType.Secondary} state={stageStatusesMap[state]}>
         {' '}
      </Status>
   );

   if (!additional) {
      return status;
   }

   return <Popover content={<>{additional}</>}>{status}</Popover>;
};

interface Props {
   stageId: string;
   title: ReactNode;
}

export const StageCard: React.FC<Props> = React.memo(({ stageId, children, title }) => {
   const { rawStage } = useStage(stageId);
   return (
      <Card className={classes.card}>
         <StageStatusBadge stageId={stageId} />
         <div>
            <div className={classes.header}>
               <div className={classes.title}>{title ?? stageId}</div>
            </div>
            <div className={classes.updateTime}>
               Updated on{' '}
               {formatDate(
                  new Date(rawStage?.spec?.[(Symbol.for('timestamp') as any) as keyof TStageSpec] as string),
                  'MMM d yyyy, H:mm',
               )}
            </div>
            {children}
         </div>
      </Card>
   );
});

StageCard.displayName = 'StageCard';
