import React, { ReactNode } from 'react';
import { formatDistanceToNowStrict } from 'date-fns';
import { formatDate } from '@yandex-infracloud-ui/libs';
import classes from './FormatDate.module.css';

interface Props {
   timestamp?: number | Duration | Date;
   empty?: ReactNode | string;
}

export const FormatDate: React.FC<Props> = ({ timestamp, empty }) => {
   if (!timestamp) {
      return <>{empty || null}</>;
   }

   let lastSeenDate: number;
   if (typeof timestamp === 'number') {
      lastSeenDate = timestamp / 1000;
   } else if (timestamp instanceof Date) {
      lastSeenDate = (timestamp as Date).getTime();
   } else {
      lastSeenDate = ((timestamp as Duration).seconds ?? 0) * 1000;
   }

   const timeStr = formatDate(new Date(lastSeenDate), 'long'); // TODO: заменить, когда number прорастет в библиотечную функцию
   const deltaStr = formatDistanceToNowStrict(lastSeenDate);

   return (
      <span>
         {timeStr} <span className={classes.delta}>{deltaStr} ago</span>
      </span>
   );
};
