import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './Ants.module.css';

interface Props {
   isChanged: boolean;
   className: string;
}

export const Ants: React.FC<Props> = ({ isChanged, className }) => (
   <div className={classNames(classes.antsContainer, isChanged ? classes.sizeChange : classes.sizeDefault, className)}>
      <div className={classes.circleOuter}>
         <div className={classes.circleInner} />
      </div>
      <div className={classes.ants} />
   </div>
);

Ants.displayName = 'Pod__Ants';
