import { classNames } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';
import classes from './HistoryEvent.module.css';

export interface HistoryEventRow {
   title?: string;
   content: ReactNode;
   key: string;
}

interface Props {
   isChanged: boolean;
   title: string;
   message?: string;
   rows?: HistoryEventRow[];
}

export const HistoryEvent: React.FC<Props> = ({ rows = [], title, message, isChanged }) => {
   const eventContent: ReactNode[] = [];
   rows.forEach(({ title: rowTitle, content, key }) => {
      if (content) {
         eventContent.push(
            <div key={`${key}-title`} className={classes.rowTitle}>
               {rowTitle}
            </div>,
            <div key={`${key}-value`} className={classes.value}>
               {content}
            </div>,
         );
      }
   });

   return (
      <div className={classes.eventContent}>
         <div className={classNames(classes.row, isChanged ? classes.changed : undefined)}>{title}</div>
         {message && <div className={classes.row}>{message}</div>}
         <div className={classes.eventRows}>{eventContent}</div>
      </div>
   );
};

HistoryEvent.displayName = 'Pod__HistoryEvent';
