import React from 'react';
import { classNames } from '@yandex-infracloud-ui/libs';
import classes from './InfoGroup.module.css';

interface Props {
   title?: string;
   margin?: 'row' | 'normal';
   titleView?: 'bold' | 'normal';
   className?: string;
}

export const InfoGroup: React.FC<Props> = ({ title, margin, titleView, children, className }) => (
   <div className={classNames(classes.group, { [classes.marginRow]: margin === 'row' }, className)}>
      {title && (
         <div className={classNames(classes.title, { [classes.titleNormal]: titleView === 'normal' })}>{title}</div>
      )}
      <div>{children}</div>
   </div>
);

InfoGroup.displayName = 'InfoGroup';
