import React, { useMemo } from 'react';

import { json } from '@yandex-infracloud-ui/libs';

import { TAttributeDictionary } from '../../../proto-typings';
import { DefinitionList, DefinitionListItem } from '../../lib';
import { InfoGroup } from '../InfoGroup/InfoGroup';

const getContent = (item: any) => {
   switch (typeof item) {
      case 'boolean':
      case 'bigint':
      case 'number':
      case 'string':
         return item.toString();

      case 'object':
         try {
            return json(item);
         } catch {
            return undefined;
         }
   }

   return undefined;
};

interface Props {
   labels?: TAttributeDictionary;
   responsive?: boolean;
}

export const Labels: React.FC<Props> = ({ labels = {}, responsive }) => {
   const fields = useMemo(
      () =>
         Object.keys(labels).map(
            key =>
               ({
                  name: key,
                  content: getContent(labels[key]),
               } as DefinitionListItem),
         ),
      [labels],
   );

   return fields.length ? (
      <InfoGroup title={'Labels'} margin={'row'}>
         <DefinitionList items={fields} responsive={responsive} />
      </InfoGroup>
   ) : null;
};

Labels.displayName = 'Labels';
