import React, { ReactNode } from 'react';

import classes from './PageTemplate.module.css';

interface Props {
   navigation: ReactNode;
   error?: ReactNode;
   controls?: ReactNode;
}

export const PageTemplate: React.FC<Props> = ({ navigation, error, controls, children }) => (
   <div className={classes.template}>
      <div className={classes.navigation}>{navigation}</div>
      {error ? <div className={classes.error}>{error}</div> : null}
      <div className={classes.contentContainer}>
         {controls}
         {children}
      </div>
   </div>
);

PageTemplate.displayName = 'PageTemplate';
