import { formatNumber } from '@yandex-infracloud-ui/libs';
import React from 'react';

const EMPTY_VALUE = '—';

interface Props {
   title?: string;
   value?: number;
   format?: string;
   suffix?: string;
   className?: string;
}

export const Resource: React.FC<Props> = ({ title, value, format, suffix, className }) =>
   value !== undefined ? (
      <div className={className}>
         {title && <span>{title}: </span>}
         <span>{`${formatNumber(value, format)}${suffix ?? ''}`}</span>
      </div>
   ) : (
      <span>{EMPTY_VALUE}</span>
   );

Resource.displayName = 'PodsSetsResourceTable__Resource';
