import { TableColumnConfig } from '@yandex-cloud/uikit';
import { ReactNode } from 'react';

export interface PodSetResourcesRowItem {
   podSetId?: ReactNode;
   serviceId?: ReactNode;
   cpu?: ReactNode;
   memory?: ReactNode;
   network?: ReactNode;
   ipAddresses?: ReactNode;
   hddCapacity?: ReactNode;
   hddBandwidth?: ReactNode;
   ssdCapaciry?: ReactNode;
   ssdBandwidth?: ReactNode;
   gpu?: ReactNode;
}

export const columns: TableColumnConfig<PodSetResourcesRowItem>[] = [
   {
      id: 'podSetId',
      name: 'Pod set ID',
   },
   {
      id: 'serviceId',
      name: 'Service ID',
   },
   {
      id: 'cpu',
      name: 'CPU',
   },
   {
      id: 'memory',
      name: 'Memory',
   },
   {
      id: 'network',
      name: 'Network',
   },
   {
      id: 'ipAddresses',
      name: 'IP addresses',
   },
   {
      id: 'hddCapacity',
      name: 'HDD capacity',
   },
   {
      id: 'hddBandwidth',
      name: 'HDD bandwidth',
   },
   {
      id: 'ssdCapaciry',
      name: 'SSD capacity',
   },
   {
      id: 'ssdBandwidth',
      name: 'SSD bandwidth',
   },
   {
      id: 'gpu',
      name: 'GPU usage',
   },
];
