import { TableColumnConfig } from '@yandex-cloud/uikit';
import { ReactNode } from 'react';

export interface PodSetRowItem {
   podSetId?: ReactNode;
   serviceId?: ReactNode;
   accountId?: ReactNode;
   nodeSegment?: string;
   nodeFilter?: ReactNode;
   antiaffinityConstraints?: ReactNode;
   deployEngine?: string;
}

export const columns: TableColumnConfig<PodSetRowItem>[] = [
   {
      id: 'podSetId',
      name: 'Pod set ID',
   },
   {
      id: 'serviceId',
      name: 'Service ID',
   },
   {
      id: 'deployEngine',
      name: 'Deploy engine',
   },
   {
      id: 'accountId',
      name: 'Account ID',
   },
   {
      id: 'nodeSegment',
      name: 'Node segment',
   },
   {
      id: 'nodeFilter',
      name: 'Node filter',
   },
   {
      id: 'antiaffinityConstraints',
      name: 'Antiaffinity constraints',
   },
];
